//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\RatingList.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/* 
$Header: RatingList.java, 9, 12/28/00 1:06:54 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         12/28/00 1:06:54 PM  Schwartz, Joe   Added
      version control header info.
 8    Alkindi Development1.7         12/26/00 7:21:17 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/26/00 6:57:25 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/18/00 12:05:39 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 5    Alkindi Development1.4         12/15/00 6:21:00 PM  Schwartz, Joe  
      Chagned internal storage to ArrayList.
 4    Alkindi Development1.3         11/14/00 12:53:14 PM Schwartz, Joe   
 3    Alkindi Development1.2         10/19/00 1:12:17 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 2    Alkindi Development1.1         10/6/00 4:13:42 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:11:13 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * A list of Rating objects.
 */
public class RatingList implements Serializable 
{
	private ArrayList internalList;
	
	public RatingList() 
	{
		internalList = new ArrayList();
	}
	
	/**
	 * @roseuid 39D35F550119
	 */
	public boolean add(Rating itemToAdd) 
	{
		return internalList.add(itemToAdd);
	}
	
	/**
	 * @roseuid 39D3699401B5
	 */
	public Rating get(int idx) 
	{
		return (Rating)internalList.get(idx);
	}
	
	/**
	 * @roseuid 39D36995033C
	 */
	public Iterator iterator() 
	{
		return internalList.iterator();
	}
	
	/**
	 * @roseuid 39D36996036B
	 */
	public RatingList(int numInit) 
	{
		internalList = new ArrayList(numInit);
	}
	
	/**
	 * This constructor take a SystemUser and  ProductList as its arguments. It make a list of ratings for the given user products with evaluation zero.
	 * @roseuid 39EF08EE00DA
	 */
	public RatingList(SystemUser user, ProductList productList) 
	{
		internalList = new ArrayList();
		for (int idx = productList.size(); --idx > -1; ) {
			Rating rat = new Rating(user, productList.get(idx), 0);
			this.add(rat);
		}
	}
	
	/**
	 * @roseuid 39D36998000F
	 */
	public int size() 
	{
		return internalList.size();
	}
	
	/**
	 * @roseuid 39EEF8F2002E
	 */
	public ProductList toProductList() 
	{
		ProductList pl = new ProductList();
		for (int idx = 0; idx < this.size(); idx ++) {
			pl.add(this.get(idx).prod);
		}
		return pl;
	}
}
